# Session configuration

The session data for each visitor is stored on your web server, while a cookie containing a session ID is stored on the visitor's machine.
This cookie allows your application to **remember** the session for that user and retrieve their session data on subsequent requests to your application.

Following session storages are available out of the box:

- File System
- PDO
- Memcached
- APC / APCu
- Redis
- Wincache
- DBA
- Memory (Arrays)

Before using sessions, make sure an application key has been specified in the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

```php
  'session' => array(

      // Session storage 'cookie', 'file', 'pdo', 'memcached', 'apc',
      // 'redis', 'dba', 'wincache', 'memory'
      'storage' => 'file',

      // If using file storage - default is null
      'storage_path' => 'app/MyFirstBlog/_session/',

      // If using the PDO (database) session storage
      'database' => array(
        'storage' => 'sqlite',
        'database' => 'app/MyFirstBlog/_session/blog-session.db',
      ),

      // Garbage collection has a 2% chance of occurring
      // for any given request to the application. Feel free
      // to tune this to your requirements.
      'garbage_collection' => array(2, 100),

      // Session lifetime number of minutes
      'lifetime' => 60,

      // Session expiration on web browser close
      'expire_on_close' => false,

      // Session cookie name
      'cookie' => 'pimf_session',

      // Session cookie path
      'path' => '/',

      // Domain for which the session cookie is available.
      'domain' => null,

      // If the cookie should only be sent over HTTPS.
      'secure' => false,
  ),
```

### Cookie Storage
Cookie based sessions provide a light-weight and fast mechanism for storing session information. They are also secure. Each cookie is encrypted
using strong AES-256 encryption. However, cookies have a four kilobyte storage limit, so you may wish to use another storage if you are storing
a lot of data in the session. To get started using cookie sessions, just set the storage option in the
[config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

### File System Storage
If your application will work great using file system sessions. However, if your application receives heavy traffic or runs on a server farm,
use database or Memcached sessions. To get started using file system sessions, just set the storage option in the
[config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.
File system sessions are stored in the 'app/YourAppName/_session/' directory, so make sure it's writeable.

### Database Storage
To start using database sessions, you will first need to configure your database connection. Next, you will need to create a session table.
However, you may also use PIMF's command-line to generate the table for you!

    php pimf core:create_session_table


### Memcached Storage
Before using Memcached sessions, you must configure your Memcached servers. Just set the storage in the
[config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.


### Redis Storage
Before using Redis sessions, you must configure your Redis servers. Just set the storage in the
[config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.


### DBA Storage
The DBA is ultra-fast session storage that uses the database (dbm-style) abstraction layer to cache/store your PHP objects, strings, integers or arrays. You don`t have
to matter about the size of the cache-file. It depends on the free space of your disk. You have to compile your PHP **–enable-dba=shared** and
**–with-[qdbm|flatfile|db4]** before using it.

### In-Memory Storage
The **memory** session storage just uses a simple array to store your session data for the current request. This storage is perfect for unit
testing your application since nothing is written to disk. It shouldn't ever be used as a **real** session storage.
